
/**
 ******************************************************************************
 *
 * @file        MG32x02z_USBD_Core.h
 * @brief       This file contains all the functions prototypes for the USB core 
 *              firmware library.
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.02
 * @date        2022/09/26
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
 
#ifndef _USB_REG_H
#define _USB_REG_H


/* Includes ------------------------------------------------------------------*/
#include "MG32x02z.h"
#include "MG32x02z__ExtraStruct.h"
#include "MG32x02z_USB_Init.h"
#include "MG32x02z_USBD_Descriptor.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
typedef struct
{
    uint8_t  bmRequest;
    uint8_t  bRequest;
    uint16_t wValue;
    uint16_t wLength;
}USB_ReuestTypeDef;
 
typedef struct
{
        uint32_t    USBStatus;              
        uint8_t     RxTx[EP0_PACKET_SIZE];                 // For Rx/Tx 
  __I   uint8_t     *Buf;                                  // USB Tx Buffer Address , Maybe addressing to ROM address
        uint32_t    All;                                   // Transmit All size in byte
        uint8_t     KeyIRQFlag;                            // Key interrupt flag.
        uint8_t     DataStage;                             // Index the next transaction are DATASTAGE or STATUSSTAGE
        uint8_t     Tmp;					               // Store some data for Next transaction( SET_ADDRESS/SET_CONFIGURATION/..)
        uint8_t     AudioOUT_AltSet;                       // For Set Interface ( Speaker)
        uint8_t     AudioIN_AltSet;                        // For Set Interface ( MIC/LINE_IN)
        uint8_t     __Reserved[3];                         // Reserved byte.
#if MG_USB_LPM_EN == 1
        uint8_t     LPM_BLE;
#endif
}USBCTR_TypeDef;                                        

/* Private define ------------------------------------------------------------*/
/**
 * @name	============== Data type  ==============
 *   		
 */ 
///@{
#define LOBYTE( V1 )            ((uint8_t)((V1) & 0xFF))
#define HIBYTE( V1 )            ((uint8_t)((V1) >> 8))
///@}

/**
 * @name	============== USB protocal ==============
 *   		
 */ 
///@{    
//-----Standard Request Code-----//
#define GET_STATUS              0	 
#define CLEAR_FRATURE           1
#define SET_FEATURE             3
#define SET_ADDRESS             5
#define GET_DESCRIPTOR          6
#define SET_DESCRIPTOR          7
#define GET_CONFIGURATION       8
#define SET_CONFIGURATION       9
#define GET_INTERFACE           10
#define SET_INTERFACE           11
#define SYNCH_FRAME             12
    
// CLASS Request Codes    
#define GET_REPORT              0x01
#define GET_IDLE                0x02
#define GET_PROTOCOL            0x03
#define SET_REPORT              0x09
#define SET_IDLE                0x0A
#define SET_PROTOCOL            0x0B

//-----------------------------------------------
//bmRequestType
#define GET_REQUEST             0x80                 
#define SET_REQUEST             0x00
      
#define STANDARD_REQUEST        0x00                
#define CLASS_REQUEST           0x20
#define VENDOR_REQUEST          0x40

//-----Request Type in Standard Request Code-----//
#define DEVICEREQUEST           0x00
#define INTERFACEREQUEST        0x01
#define ENDPOINTREQUEST         0x02

//-----Feature Selectors in Standard Request Code-----//
#define DEVICE_REMOTE_WAKEUP    0x01
#define ENDPOINT_HALT           0x00

//-----Descriptor Type in Standard Request Code-----//
#define DEVICE_DESCRIPTOR       0x01
#define CONFIGURATION_DESCRIPTOR  0x02
#define STRING_DESCRIPTOR       0x03
#define INTERFACE_DESCRIPTOR    0x04
#define ENDPOINT_DESCRIPTOR     0x05
#define BOS_DESCRIPTOR          0x0F
#define DEVICE_CAPABILTY_DESCRIPTOR  0x10

//-----Descriptor Type in class Request Code ( HID) -----//
#define HID_DESCRIPTOR          0x21
#define HID_REPORT              0x22


//==============================================
//USB Endpoint Descriptor
#define USB_EP_OUT              0x00
#define USB_EP_IN               0x80
    
#define USB_EP_0                0x00
#define USB_EP_1                0x01
#define USB_EP_2                0x02
#define USB_EP_3                0x03
#define USB_EP_4                0x04
#define USB_EP_5                0x05
#define USB_EP_6                0x06
#define USB_EP_7                0x07
#define USB_EP_8                0x08
#define USB_EP_9                0x09
#define USB_EP_10               0x0A
#define USB_EP_11               0x0B
#define USB_EP_12               0x0C
#define USB_EP_13               0x0D
#define USB_EP_14               0x0E
#define USB_EP_15               0x0F
    
#define USB_EP_CONTROL          0x00
#define USB_EP_ISOCHRONOUS      0x01
#define USB_EP_BULK             0x02
#define USB_EP_INTERRUPT        0x03
    
#define USB_EP_NO_SYNC          0x00              
#define USB_EP_ASYNC            0x04
#define USB_EP_ADAPTIVE         0x08
#define USB_EP_SYNC             0x0C
    
#define USB_EP_DATA             0x00
#define USB_EP_FEEDBACK         0x10
#define USB_EP_IMPLICIT         0x20    
///@}    
    
/**
 * @name	============== USB control ==============
 *   		
 */ 
///@{     
#define USB_STATUS_DEFAULT          0x00000000
#define USB_STATUS_EMULATION_MASK   0x80000000
    #define USB_STATUS_EMULATION_OK     0x80000000
    #define USB_STATUS_EMULATION_NO     0x00000000
#define USB_STATUS_RWEN_MASK        0x40000000
    #define USB_STATUS_RWEN_ENABLE      0x40000000
    #define USB_STATUS_RWEN_DISABLE     0x00000000
#define USB_STATUS_BUS_MASK         0x00FF0000
    #define USB_STATUS_BUS_ACT          0x00000000
    #define USB_STATUS_BUS_RESET        0x00010000
    #define USB_STATUS_BUS_SUSPEND      0x00020000
    #define USB_STATUS_BUS_RESUME       0x00040000
    #define USB_STATUS_BUS_EXTIEVENT_WAKEUP 0x00080000
#define USB_STATUS_COUNT_MASK           0x000000FF
///@}

#define EP0                     0x00	     // EPO 
#define EP1                     0x01      // EP1
#define EP2                     0x02      // EP2
#define EP3                     0x03      // EP3
#define EP4                     0x04      // EP4
#define EP5                     0x05      // EP5
#define EP6                     0x06      // EP6
#define EP7                     0x07      // EP7
            
#define SETUPSTAGE              0xF0
#define DATASTAGE               0x5A
#define DATASTAGE_SRP           0x5B
#define STATUSSTAGE             0xA5
#define SETADDRESS              0x55    
            
#define INTF0_EP1_Max           0x20
#define INTF1_EP2_Max           0x20
#define INTF2_EP3_Max           0x20
#define INTF3_EP4_Max           0x10
            
#define INTF0_Buf_Max           INTF0_EP1_Max * 1
#define INTF1_Buf_Max           INTF1_EP2_Max * 1
#define INTF2_Buf_Max           INTF2_EP3_Max * 1
#define INTF3_Buf_Max           INTF3_EP4_Max * 1

/**
 * @name	============== DFU Relationship ==============
 *
 */ 
///@{
#define DFU_STAGE               0x33
#define DFU_RESET               0x44
///@}
    
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void USB_Inital(void);
void USB_Int( void );
void API_USBD_ControlRead( void );

void USB_WriteEndpointData( USB_EP_Struct* EPX, __I uint8_t *Buffer , uint32_t TXShift , uint8_t Cnt );
void USB_WriteEndpointSingleData( USB_EP_Struct* EPX, uint8_t sData , uint8_t shift);
void USB_WriteEndpointConstData( USB_EP_Struct* EPX, uint8_t ConstData , uint32_t cTXShift , uint8_t cTXCnt );
void USB_ReadEndpointData( USB_EP_Struct* EPX, uint8_t *Buffer , uint32_t RXShift , uint32_t Cnt);
    
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/
extern USBCTR_TypeDef Ep0;



#endif   
